/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.LogFileList;
import uk.org.simonsite.log4j.appender.TimeAndSizeRollingAppender;
import uk.org.simonsite.log4j.appender.g;

abstract class AbstractLogFileScavenger
implements Runnable,
g {
    private TimeAndSizeRollingAppender appender = null;
    private File file = null;
    private AppenderRollingProperties properties = null;
    private volatile Thread threadRef = null;

    AbstractLogFileScavenger() {
    }

    @Override
    public final void init(TimeAndSizeRollingAppender timeAndSizeRollingAppender, AppenderRollingProperties appenderRollingProperties) {
        this.appender = timeAndSizeRollingAppender;
        this.properties = appenderRollingProperties;
    }

    @Override
    public final synchronized void begin() {
        if (this.threadRef == null) {
            this.file = this.getAppender().getIoFile();
            if (this.file == null) {
                this.getAppender().getErrorHandler().error("Scavenger not started: missing log file name");
                return;
            }
            if (this.getProperties().getScavengeInterval() > -1L) {
                Thread thread;
                this.threadRef = thread = new Thread((Runnable)this, "Log4J File Scavenger");
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    @Override
    public final synchronized void end() {
        Thread thread = this.threadRef;
        this.threadRef = null;
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public final void run() {
        LogLog.debug((String)(this.getClass().getName() + " started"));
        try {
            while (this.isRunning()) {
                this.a();
                try {
                    long l2 = this.getProperties().getScavengeInterval();
                    if (l2 <= 0L) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Exception exception) {
            this.getAppender().getErrorHandler().error("Log file scavenger failed", exception, 0);
        }
        LogLog.debug((String)"Log file scavenger stopped");
    }

    public final boolean isRunning() {
        Thread thread = this.threadRef;
        if (thread != null) {
            return !thread.isInterrupted();
        }
        return false;
    }

    final TimeAndSizeRollingAppender getAppender() {
        return this.appender;
    }

    final AppenderRollingProperties getProperties() {
        return this.properties;
    }

    final LogFileList logFileList() {
        final String string = this.file.getName();
        return new LogFileList(this.file, new FilenameFilter(){

            @Override
            public final boolean accept(File file, String string2) {
                return !string2.equals(string) && string2.startsWith(string);
            }
        }, this.getProperties());
    }
}

