/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.util.Locale;
import java.util.TimeZone;
import uk.org.simonsite.log4j.helpers.SynchronizedCountingQuietWriter;

final class AppenderRollingProperties {
    private final Object compressionLock = new Object();
    private final Object countingWriterLock = new Object();
    private final Object scavengerLock = new Object();
    private final Object rollTimeLock = new Object();
    private final Object startupRollLock = new Object();
    private long maxFileSize = 0xA00000L;
    private int maxRollFileCount = 10;
    private String datePattern = "'.'yyyy-MM-dd";
    private Locale datePatternLocale = null;
    private TimeZone timeZone = null;
    private boolean dateRollEnforced = false;
    private long scavengeInterval = 30000L;
    private long minFreeDiscSpace = -1L;
    private String compressionAlgorithm = "";
    private int compressionLevel = 1;
    private long compressionMaxWait = 30000L;
    private int compressionMinQueueSize = 0;
    private boolean compressionBlocking = false;
    private SynchronizedCountingQuietWriter countingQuietWriter = null;
    private long nextRollOverTime = 0L;
    private boolean rollOnStartup = false;
    private boolean rolledOnStartup = false;
    private boolean activatingAppender = false;

    AppenderRollingProperties() {
    }

    final boolean isActivatingAppender() {
        return this.activatingAppender;
    }

    final void setActivatingAppender(boolean bl) {
        this.activatingAppender = bl;
    }

    final long getBytesWrittenCount() {
        Object object = this.countingWriterLock;
        synchronized (object) {
            return this.countingQuietWriter != null ? this.countingQuietWriter.getCount() : 0L;
        }
    }

    final void setBytesWrittenCount(long l2) {
        Object object = this.countingWriterLock;
        synchronized (object) {
            if (this.countingQuietWriter != null) {
                this.countingQuietWriter.setCount(l2);
            }
            return;
        }
    }

    final SynchronizedCountingQuietWriter getCountingQuietWriter() {
        Object object = this.countingWriterLock;
        synchronized (object) {
            return this.countingQuietWriter;
        }
    }

    final void setCountingQuietWriter(SynchronizedCountingQuietWriter synchronizedCountingQuietWriter) {
        Object object = this.countingWriterLock;
        synchronized (object) {
            this.countingQuietWriter = synchronizedCountingQuietWriter;
            return;
        }
    }

    final String getDatePattern() {
        if (this.datePattern != null) {
            return this.datePattern;
        }
        return "";
    }

    final void setDatePattern(String string) {
        this.datePattern = string;
    }

    final Locale getDatePatternLocale() {
        if (this.datePatternLocale != null) {
            return this.datePatternLocale;
        }
        return Locale.ENGLISH;
    }

    final void setDatePatternLocale(Locale locale) {
        this.datePatternLocale = locale;
    }

    final TimeZone getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        return TimeZone.getDefault();
    }

    final void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    final boolean isDateRollEnforced() {
        return this.dateRollEnforced;
    }

    final void setDateRollEnforced(boolean bl) {
        this.dateRollEnforced = bl;
    }

    final long getNextRollOverTime() {
        long l2;
        Object object = this.rollTimeLock;
        synchronized (object) {
            l2 = this.nextRollOverTime;
            this.rollTimeLock.notifyAll();
        }
        return l2;
    }

    final long getNextRollOverTimeWithWait() {
        long l2;
        Object object = this.rollTimeLock;
        synchronized (object) {
            while (this.nextRollOverTime == 0L) {
                try {
                    this.rollTimeLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            l2 = this.nextRollOverTime;
            this.rollTimeLock.notifyAll();
        }
        return l2;
    }

    final void setNextRollOverTime(long l2) {
        Object object = this.rollTimeLock;
        synchronized (object) {
            this.nextRollOverTime = l2;
            this.rollTimeLock.notifyAll();
            return;
        }
    }

    final synchronized long getMaxFileSize() {
        return this.maxFileSize;
    }

    final synchronized void setMaxFileSize(long l2) {
        if (l2 >= 0L) {
            this.maxFileSize = l2;
        }
    }

    final boolean shouldRollOnStartup() {
        Object object = this.startupRollLock;
        synchronized (object) {
            return this.rollOnStartup;
        }
    }

    final void setRollOnStartup(boolean bl) {
        Object object = this.startupRollLock;
        synchronized (object) {
            this.rollOnStartup = bl;
            return;
        }
    }

    final boolean wasRolledOnStartup() {
        Object object = this.startupRollLock;
        synchronized (object) {
            return this.rolledOnStartup;
        }
    }

    final boolean updateRolledOnStartup() {
        Object object = this.startupRollLock;
        synchronized (object) {
            if (this.rolledOnStartup) {
                return false;
            }
            this.rolledOnStartup = true;
            return this.rollOnStartup;
        }
    }

    final boolean shouldRollOnActivation() {
        Object object = this.startupRollLock;
        synchronized (object) {
            return this.rollOnStartup && !this.rolledOnStartup;
        }
    }

    final int getMaxRollFileCount() {
        Object object = this.scavengerLock;
        synchronized (object) {
            return this.maxRollFileCount;
        }
    }

    final void setMaxRollFileCount(int n) {
        Object object = this.scavengerLock;
        synchronized (object) {
            if (n >= 0) {
                this.maxRollFileCount = n;
            }
            return;
        }
    }

    final long getMinFreeDiscSpace() {
        Object object = this.scavengerLock;
        synchronized (object) {
            return this.minFreeDiscSpace;
        }
    }

    final void setMinFreeDiscSpace(long l2) {
        Object object = this.scavengerLock;
        synchronized (object) {
            if (l2 >= 0L) {
                this.minFreeDiscSpace = l2;
            }
            return;
        }
    }

    final long getScavengeInterval() {
        Object object = this.scavengerLock;
        synchronized (object) {
            return this.scavengeInterval;
        }
    }

    final void setScavengeInterval(long l2) {
        Object object = this.scavengerLock;
        synchronized (object) {
            if (l2 >= -1L) {
                this.scavengeInterval = l2;
            }
            return;
        }
    }

    final String getCompressionAlgorithm() {
        Object object = this.compressionLock;
        synchronized (object) {
            return this.compressionAlgorithm;
        }
    }

    final void setCompressionAlgorithm(String string) {
        Object object = this.compressionLock;
        synchronized (object) {
            this.compressionAlgorithm = string != null ? string.trim() : "";
            return;
        }
    }

    final long getCompressionMaxWait() {
        Object object = this.compressionLock;
        synchronized (object) {
            return this.compressionMaxWait;
        }
    }

    final void setCompressionMaxWait(long l2) {
        Object object = this.compressionLock;
        synchronized (object) {
            if (l2 >= 0L) {
                this.compressionMaxWait = l2;
            }
            return;
        }
    }

    final int getCompressionLevel() {
        Object object = this.compressionLock;
        synchronized (object) {
            return this.compressionLevel;
        }
    }

    final void setCompressionLevel(int n) {
        Object object = this.compressionLock;
        synchronized (object) {
            if (n >= -1 && n <= 9) {
                this.compressionLevel = n;
            }
            return;
        }
    }

    final boolean isCompressionBlocking() {
        Object object = this.compressionLock;
        synchronized (object) {
            return this.compressionBlocking;
        }
    }

    final void setCompressionBlocking(boolean bl) {
        Object object = this.compressionLock;
        synchronized (object) {
            this.compressionBlocking = bl;
            return;
        }
    }

    final int getCompressionMinQueueSize() {
        Object object = this.compressionLock;
        synchronized (object) {
            return this.compressionMinQueueSize;
        }
    }

    final void setCompressionMinQueueSize(int n) {
        Object object = this.compressionLock;
        synchronized (object) {
            if (n >= 0) {
                this.compressionMinQueueSize = n;
            }
            return;
        }
    }
}

