/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.LogFileCompressionStrategy;
import uk.org.simonsite.log4j.appender.TimeSuffixHelper;

final class BackupSuffixHelper {
    private Pattern pattern = null;
    private final TimeSuffixHelper timeHelper;

    BackupSuffixHelper(AppenderRollingProperties appenderRollingProperties) {
        this.timeHelper = new TimeSuffixHelper(appenderRollingProperties);
    }

    final String defaultBackupCountAsString() {
        return Integer.toString(this.defaultBackupCount());
    }

    final String nextBackupCountAsString(String string, File file) {
        int n = this.backupCount(string, file);
        return Integer.toString(n + 1);
    }

    final Number[] backupTimeAndCount(String object, File object2) {
        object = ((Pattern)(object2 = this.backupCountPattern((File)object2))).matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            object2 = ((Matcher)object).group(2);
            object = ((Matcher)object).group(4);
            long l2 = this.timeHelper.toTime((String)object2);
            int n = this.backupCountFromString((String)object);
            return new Number[]{l2, n};
        }
        return new Number[]{0L, 0};
    }

    final String backupTimeAsString(String object, File serializable) {
        object = ((Pattern)(serializable = this.backupCountPattern((File)serializable))).matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            return ((Matcher)object).group(2);
        }
        return "";
    }

    final String backupTimeAsString(long l2) {
        return this.timeHelper.toString(l2);
    }

    private int backupCount(String string, File file) {
        string = this.backupCountAsString(string, file);
        return this.backupCountFromString(string);
    }

    private String backupCountAsString(String object, File serializable) {
        object = ((Pattern)(serializable = this.backupCountPattern((File)serializable))).matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            return ((Matcher)object).group(4);
        }
        return "";
    }

    private int backupCountFromString(String string) {
        if ("".equals(string)) {
            return 0;
        }
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.defaultBackupCount();
        }
    }

    private synchronized Pattern backupCountPattern(File file) {
        if (this.pattern == null) {
            LogFileCompressionStrategy[] logFileCompressionStrategyArray = LogFileCompressionStrategy.strategies();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(\\Q").append(file.getName()).append("\\E)");
            stringBuffer.append("(.+)(\\.)([0-9]+)($");
            for (int i2 = 0; i2 < logFileCompressionStrategyArray.length; ++i2) {
                stringBuffer.append("|\\.");
                stringBuffer.append(logFileCompressionStrategyArray[i2].getAlgorithmName());
                stringBuffer.append('$');
            }
            stringBuffer.append(')');
            this.pattern = Pattern.compile(stringBuffer.toString());
        }
        return this.pattern;
    }

    private int defaultBackupCount() {
        return 1;
    }
}

