/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.io.FilenameFilter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.BackupSuffixHelper;
import uk.org.simonsite.log4j.appender.FileRollEvent;
import uk.org.simonsite.log4j.appender.LogFileList;
import uk.org.simonsite.log4j.appender.TimeAndSizeRollingAppender;
import uk.org.simonsite.log4j.appender.c;
import uk.org.simonsite.log4j.appender.d;
import uk.org.simonsite.log4j.helpers.FileHelper;

final class FileRoller
implements d {
    private final TimeAndSizeRollingAppender appender;
    private final AppenderRollingProperties properties;
    private final BackupSuffixHelper backupSuffixHelper;
    private final List fileRollEventListeners = Collections.synchronizedList(new ArrayList());

    FileRoller(TimeAndSizeRollingAppender timeAndSizeRollingAppender) {
        this.appender = timeAndSizeRollingAppender;
        this.properties = timeAndSizeRollingAppender.getProperties();
        this.backupSuffixHelper = new BackupSuffixHelper(this.properties);
    }

    @Override
    public final void addFileRollEventListener(c c2) {
        this.fileRollEventListeners.add(c2);
    }

    @Override
    public final void removeFileRollEventListener(c c2) {
        this.fileRollEventListeners.remove(c2);
    }

    public final void fireFileRollEvent(FileRollEvent fileRollEvent) {
        Object[] objectArray = this.fileRollEventListeners.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            c c2 = (c)objectArray[i2];
            try {
                c2.onFileRoll(fileRollEvent);
                continue;
            }
            catch (RuntimeException runtimeException) {
                this.getAppender().getErrorHandler().error("Failed to dispatch file roll event", (Exception)runtimeException, 0);
            }
        }
    }

    final TimeAndSizeRollingAppender getAppender() {
        return this.appender;
    }

    final AppenderRollingProperties getProperties() {
        return this.properties;
    }

    final void roll(long l2) {
        File file = this.prepareBackupFile(l2);
        this.getAppender().closeFile();
        FileRoller fileRoller = this;
        fileRoller.doFileRoll(fileRoller.getAppender().getIoFile(), file);
        this.getAppender().openFile();
        this.fireFileRollEvent(new FileRollEvent(this, file));
    }

    private File prepareBackupFile(long l2) {
        Object object = this.backupSuffixHelper.backupTimeAsString(l2);
        object = new BackupFile(this.getAppender().getIoFile(), (String)object);
        Object object2 = this.logFileListFilteredOn((BackupFile)object);
        String string = this.backupSuffixHelper.defaultBackupCountAsString();
        if (!((AbstractCollection)object2).isEmpty()) {
            object2 = ((LogFileList)object2).lastFile();
            string = this.backupSuffixHelper.nextBackupCountAsString(((File)object2).getName(), ((BackupFile)object).getBaseFile());
        }
        ((BackupFile)object).setBackupCountSuffix(string);
        return ((BackupFile)object).getBackupFile();
    }

    private LogFileList logFileListFilteredOn(BackupFile backupFile) {
        LogLog.debug((String)"Reading in list of existing log files");
        final String string = backupFile.getTimeSuffixedFile().getName();
        return new LogFileList(backupFile.getBaseFile(), new FilenameFilter(){

            @Override
            public final boolean accept(File file, String string2) {
                return string2.startsWith(string);
            }
        }, this.getProperties());
    }

    private void doFileRoll(File file, File file2) {
        FileHelper fileHelper = FileHelper.getInstance();
        if (!fileHelper.deleteExisting(file2)) {
            this.getAppender().getErrorHandler().error("Unable to delete existing " + file2 + " for rename");
        }
        String string = file.toString();
        if (fileHelper.rename(file, file2)) {
            LogLog.debug((String)("Renamed " + string + " to " + file2));
            return;
        }
        this.getAppender().getErrorHandler().error("Unable to rename " + string + " to " + file2);
    }

    private static final class BackupFile {
        private final File baseFile;
        private final File timeSuffixedFile;
        private String backupCountSuffix = "";

        BackupFile(File file, String string) {
            this.baseFile = file;
            this.timeSuffixedFile = new File(file.getAbsoluteFile() + string);
        }

        final void setBackupCountSuffix(String string) {
            this.backupCountSuffix = string;
        }

        final File getBaseFile() {
            return this.baseFile;
        }

        final File getTimeSuffixedFile() {
            return this.timeSuffixedFile;
        }

        final File getBackupFile() {
            return new File(this.timeSuffixedFile.getPath() + '.' + this.backupCountSuffix);
        }
    }
}

