/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.CompositeRoller;
import uk.org.simonsite.log4j.appender.FileRollEvent;
import uk.org.simonsite.log4j.appender.FileRoller;
import uk.org.simonsite.log4j.appender.LogFileCompressor;
import uk.org.simonsite.log4j.appender.ScheduledFileRollEvent;
import uk.org.simonsite.log4j.appender.StartupFileRollEvent;
import uk.org.simonsite.log4j.appender.TimeBasedRollEnforcer;
import uk.org.simonsite.log4j.appender.a;
import uk.org.simonsite.log4j.appender.b;
import uk.org.simonsite.log4j.appender.c;
import uk.org.simonsite.log4j.appender.d;
import uk.org.simonsite.log4j.appender.e;
import uk.org.simonsite.log4j.appender.g;
import uk.org.simonsite.log4j.helpers.SynchronizedCountingQuietWriter;

public class TimeAndSizeRollingAppender
extends FileAppender
implements UnrecognizedElementHandler {
    private final AppenderRollingProperties properties = new AppenderRollingProperties();
    private e fileRollable = null;
    private FileRoller fileRoller = null;
    private g logFileScavenger = null;
    private LogFileCompressor logFileCompressor = null;
    private TimeBasedRollEnforcer logRollEnforcer = null;
    private c guestFileRollEventListener = null;
    private b guestFileCompressionEventListener = null;

    public TimeAndSizeRollingAppender() {
        this.setFileRoller(new FileRoller(this));
    }

    public TimeAndSizeRollingAppender(Layout layout, String string) throws IOException {
        this();
        this.initSuper(layout, string, super.getAppend(), super.getBufferedIO(), super.getBufferSize());
    }

    public TimeAndSizeRollingAppender(Layout layout, String string, boolean bl) throws IOException {
        this();
        this.initSuper(layout, string, bl, super.getBufferedIO(), super.getBufferSize());
    }

    public TimeAndSizeRollingAppender(Layout layout, String string, boolean bl, boolean bl2, int n) throws IOException {
        this();
        this.initSuper(layout, string, bl, bl2, n);
    }

    private void initSuper(Layout layout, String string, boolean bl, boolean bl2, int n) throws IOException {
        super.setLayout(layout);
        super.setFile(string);
        super.setAppend(bl);
        super.setBufferedIO(bl2);
        super.setBufferSize(n);
    }

    public final synchronized void activateOptions() {
        this.deactivateOptions();
        this.getProperties().setActivatingAppender(true);
        super.activateOptions();
        this.setFileRollable(new CompositeRoller(this));
        this.registerGuestFileRollEventListener();
        Object object = this.getLogFileScavenger();
        if (object == null) {
            object = this.initLogFileScavenger(new a());
        }
        object.begin();
        object = new LogFileCompressor(this);
        this.setLogFileCompressor((LogFileCompressor)object);
        this.getFileRoller().addFileRollEventListener((c)object);
        this.registerGuestFileCompressionEventListener();
        ((LogFileCompressor)object).begin();
        object = new TimeBasedRollEnforcer(this);
        this.setLogRollEnforcer((TimeBasedRollEnforcer)object);
        ((TimeBasedRollEnforcer)object).begin();
        this.rollOnStartup();
        this.getProperties().setActivatingAppender(false);
    }

    public final synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closeFile();
        this.deactivateOptions();
        this.fileName = null;
        this.closed = true;
    }

    public final boolean parseUnrecognizedElement(Element element, Properties properties) throws Exception {
        Object object;
        String string = element.getNodeName();
        if ("fileRollEventListener".equalsIgnoreCase(string) && (object = DOMConfigurator.parseElement((Element)element, (Properties)properties, c.class)) != null) {
            this.initGuestFileRollEventListener((c)object);
            return true;
        }
        if ("fileCompressionEventListener".equalsIgnoreCase(string) && (object = DOMConfigurator.parseElement((Element)element, (Properties)properties, b.class)) != null) {
            this.initGuestFileCompressionEventListener((b)object);
            return true;
        }
        if ("logFileScavenger".equalsIgnoreCase(string) && (object = DOMConfigurator.parseElement((Element)element, (Properties)properties, g.class)) != null) {
            this.initLogFileScavenger((g)object);
            return true;
        }
        return false;
    }

    public String getCompressionAlgorithm() {
        return this.getProperties().getCompressionAlgorithm();
    }

    public boolean getCompressionUseBlockingQueue() {
        return this.getProperties().isCompressionBlocking();
    }

    public long getCompressionMaxBlockingInterval() {
        return this.getProperties().getCompressionMaxWait();
    }

    public int getCompressionMinQueueSize() {
        return this.getProperties().getCompressionMinQueueSize();
    }

    public int getCompressionLevel() {
        return this.getProperties().getCompressionLevel();
    }

    public String getDatePattern() {
        return this.getProperties().getDatePattern();
    }

    public String getDatePatternLocale() {
        return this.getProperties().getDatePatternLocale().toString();
    }

    public boolean getDateRollEnforced() {
        return this.getProperties().isDateRollEnforced();
    }

    public String getFileRollEventListener() {
        if (this.getGuestFileRollEventListener() != null) {
            return this.getGuestFileRollEventListener().getClass().getName();
        }
        return String.valueOf(this.getGuestFileRollEventListener());
    }

    public String getMaxFileSize() {
        return Long.toString(this.getProperties().getMaxFileSize());
    }

    public String getMinFreeDiskSpace() {
        return Long.toString(this.getProperties().getMinFreeDiscSpace());
    }

    public int getMaxRollFileCount() {
        return this.getProperties().getMaxRollFileCount();
    }

    public boolean getRollOnStartup() {
        return this.getProperties().shouldRollOnStartup();
    }

    public long getScavengeInterval() {
        return this.getProperties().getScavengeInterval();
    }

    public String getTimeZoneId() {
        return this.getProperties().getTimeZone().getID();
    }

    public void setCompressionAlgorithm(String string) {
        if (string == null) {
            LogLog.warn((String)("Null name supplied for compression algorithm [" + this.getName() + "], defaulting to '" + this.getProperties().getCompressionAlgorithm() + '\''));
            return;
        }
        if ("".equals(string = string.trim())) {
            LogLog.warn((String)("Empty name supplied for compression algorithm [" + this.getName() + "], defaulting to '" + this.getProperties().getCompressionAlgorithm() + '\''));
            return;
        }
        this.getProperties().setCompressionAlgorithm(string);
    }

    public void setCompressionUseBlockingQueue(boolean bl) {
        this.getProperties().setCompressionBlocking(bl);
    }

    public void setCompressionMaxBlockingInterval(long l2) {
        this.getProperties().setCompressionMaxWait(l2);
    }

    public void setCompressionLevel(int n) {
        this.getProperties().setCompressionLevel(n);
    }

    public void setCompressionMinQueueSize(int n) {
        this.getProperties().setCompressionMinQueueSize(n);
    }

    public void setDatePattern(String string) {
        if (string == null) {
            LogLog.warn((String)("Null date pattern supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getDatePattern()));
            return;
        }
        if ("".equals(string = string.trim())) {
            LogLog.warn((String)("Empty date pattern supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getDatePattern()));
            return;
        }
        this.getProperties().setDatePattern(string);
    }

    public void setDatePatternLocale(String stringArray) {
        if (stringArray == null) {
            LogLog.warn((String)("Null date pattern locale supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getDatePatternLocale()));
            return;
        }
        if ("".equals(stringArray = stringArray.trim())) {
            LogLog.warn((String)("Empty date pattern locale supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getDatePatternLocale()));
            return;
        }
        stringArray = stringArray.split("_");
        switch (stringArray.length) {
            case 1: {
                this.getProperties().setDatePatternLocale(new Locale(stringArray[0]));
                return;
            }
            case 2: {
                this.getProperties().setDatePatternLocale(new Locale(stringArray[0], stringArray[1]));
                return;
            }
        }
        LogLog.warn((String)("Unable to parse date pattern locale supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getDatePatternLocale()));
    }

    public void setDateRollEnforced(boolean bl) {
        this.getProperties().setDateRollEnforced(bl);
    }

    public void setFileRollEventListener(String object) {
        if (object != null) {
            object = ((String)object).trim();
            if ((object = (c)OptionConverter.instantiateByClassName((String)object, c.class, null)) != null) {
                this.initGuestFileRollEventListener((c)object);
            }
        }
    }

    public void setLogFileScavenger(String object) {
        if (object != null) {
            object = ((String)object).trim();
            if ((object = (g)OptionConverter.instantiateByClassName((String)object, g.class, null)) != null) {
                this.initLogFileScavenger((g)object);
            }
        }
    }

    public void setFileRollEventMessage(final String string) {
        if (string != null) {
            if (!"".equals(string.trim())) {
                this.initGuestFileRollEventListener(new c(){

                    @Override
                    public final void onFileRoll(FileRollEvent fileRollEvent) {
                        fileRollEvent.dispatchToAppender(string);
                    }
                });
                return;
            }
            this.initGuestFileRollEventListener(new c(){

                @Override
                public final void onFileRoll(FileRollEvent fileRollEvent) {
                    fileRollEvent.dispatchToAppender();
                }
            });
        }
    }

    public void setMaxFileSize(String string) {
        if (string == null) {
            LogLog.warn((String)("Null max file size supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getMaxFileSize()));
            return;
        }
        if ("".equals(string = string.trim())) {
            LogLog.warn((String)("Empty max file size supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getMaxFileSize()));
            return;
        }
        long l2 = this.getProperties().getMaxFileSize();
        long l3 = OptionConverter.toFileSize((String)string, (long)l2);
        this.getProperties().setMaxFileSize(l3);
    }

    public void setMinFreeDiskSpace(String string) {
        if (string == null) {
            LogLog.warn((String)("Null min free disk space supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getMinFreeDiscSpace()));
            return;
        }
        if ("".equals(string = string.trim())) {
            LogLog.warn((String)("Empty min free disk space supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getMinFreeDiscSpace()));
            return;
        }
        long l2 = this.getProperties().getMinFreeDiscSpace();
        long l3 = OptionConverter.toFileSize((String)string, (long)l2);
        this.getProperties().setMinFreeDiscSpace(l3);
    }

    public void setMaxRollFileCount(int n) {
        this.getProperties().setMaxRollFileCount(n);
    }

    public void setRollOnStartup(boolean bl) {
        this.getProperties().setRollOnStartup(bl);
    }

    public void setScavengeInterval(long l2) {
        this.getProperties().setScavengeInterval(l2);
    }

    public void setMinFreeDiskSpace(long l2) {
        this.getProperties().setMinFreeDiscSpace(l2);
    }

    public void setTimeZoneId(String string) {
        if (string == null) {
            LogLog.warn((String)("Null time zone ID supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getTimeZone()));
            return;
        }
        if ("".equals(string = string.trim())) {
            LogLog.warn((String)("Empty time zone ID supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getTimeZone()));
            return;
        }
        TimeZone timeZone = null;
        String[] stringArray = TimeZone.getAvailableIDs();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals(string)) continue;
            timeZone = TimeZone.getTimeZone(string);
            break;
        }
        if (timeZone == null) {
            LogLog.warn((String)("Supplied time zone ID not known for appender [" + this.getName() + "], defaulting to " + this.getProperties().getTimeZone()));
            return;
        }
        this.getProperties().setTimeZone(timeZone);
    }

    final FileRoller getFileRoller() {
        return this.fileRoller;
    }

    final c getGuestFileRollEventListener() {
        return this.guestFileRollEventListener;
    }

    final b getGuestFileCompressionEventListener() {
        return this.guestFileCompressionEventListener;
    }

    final LogFileCompressor getLogFileCompressor() {
        return this.logFileCompressor;
    }

    final g getLogFileScavenger() {
        return this.logFileScavenger;
    }

    final AppenderRollingProperties getProperties() {
        return this.properties;
    }

    final File getIoFile() {
        String string = super.getFile();
        if (string == null) {
            super.getErrorHandler().error("Filename has not been set", (Exception)new IllegalStateException(), 4);
            return null;
        }
        return new File(string);
    }

    final void openFile() {
        super.activateOptions();
    }

    protected final void closeFile() {
        this.writeFooter();
        super.closeWriter();
        this.qw = null;
    }

    protected final void setQWForFiles(Writer object) {
        object = new SynchronizedCountingQuietWriter((Writer)object, super.getErrorHandler());
        this.getProperties().setCountingQuietWriter((SynchronizedCountingQuietWriter)((Object)object));
        this.qw = object;
    }

    protected final void subAppend(LoggingEvent loggingEvent) {
        if (loggingEvent instanceof ScheduledFileRollEvent) {
            TimeAndSizeRollingAppender timeAndSizeRollingAppender = this;
            synchronized (timeAndSizeRollingAppender) {
                if (this.closed) {
                    return;
                }
                this.rollFile(loggingEvent);
            }
        } else {
            if (loggingEvent instanceof FileRollEvent) {
                super.subAppend(loggingEvent);
                return;
            }
            this.rollFile(loggingEvent);
            super.subAppend(loggingEvent);
        }
    }

    protected final void writeFooter() {
        if (this.getProperties().isActivatingAppender()) {
            return;
        }
        super.writeFooter();
    }

    protected final void writeHeader() {
        if (this.getProperties().shouldRollOnActivation()) {
            return;
        }
        super.writeHeader();
    }

    private synchronized void deactivateOptions() {
        d d2;
        Object object = this.getLogFileScavenger();
        if (object != null) {
            object.end();
        }
        if ((object = this.getLogRollEnforcer()) != null) {
            ((TimeBasedRollEnforcer)object).end();
        }
        if ((object = this.getLogFileCompressor()) != null) {
            ((LogFileCompressor)object).end();
        }
        if ((d2 = this.getFileRollEventSource()) != null) {
            d2.removeFileRollEventListener((c)object);
        }
        this.deregisterGuestFileRollEventListener();
        this.deregisterGuestFileCompressionEventListener();
    }

    private void deregisterGuestFileRollEventListener() {
        d d2;
        c c2 = this.getGuestFileRollEventListener();
        if (c2 != null && (d2 = this.getFileRollEventSource()) != null) {
            d2.removeFileRollEventListener(c2);
        }
    }

    private void deregisterGuestFileCompressionEventListener() {
        LogFileCompressor logFileCompressor;
        b b2 = this.getGuestFileCompressionEventListener();
        if (b2 != null && (logFileCompressor = this.getLogFileCompressor()) != null) {
            logFileCompressor.removeFileCompressionEventListener(b2);
        }
    }

    private void registerGuestFileRollEventListener() {
        d d2;
        c c2 = this.getGuestFileRollEventListener();
        if (c2 != null && (d2 = this.getFileRollEventSource()) != null) {
            d2.addFileRollEventListener(c2);
        }
    }

    private void registerGuestFileCompressionEventListener() {
        LogFileCompressor logFileCompressor;
        b b2 = this.getGuestFileCompressionEventListener();
        if (b2 != null && (logFileCompressor = this.getLogFileCompressor()) != null) {
            logFileCompressor.addFileCompressionEventListener(b2);
        }
    }

    private void rollFile(LoggingEvent loggingEvent) {
        this.getFileRollable().roll(loggingEvent);
    }

    private void rollOnStartup() {
        if (this.getProperties().shouldRollOnActivation()) {
            this.rollFile(new StartupFileRollEvent());
        }
    }

    private e getFileRollable() {
        return this.fileRollable;
    }

    private void setFileRollable(e e2) {
        this.fileRollable = e2;
    }

    private d getFileRollEventSource() {
        return this.getFileRoller();
    }

    private void setFileRoller(FileRoller fileRoller) {
        this.fileRoller = fileRoller;
    }

    private void initGuestFileRollEventListener(c c2) {
        this.deregisterGuestFileRollEventListener();
        this.guestFileRollEventListener = c2;
    }

    private void initGuestFileCompressionEventListener(b b2) {
        this.deregisterGuestFileCompressionEventListener();
        this.guestFileCompressionEventListener = b2;
    }

    private g initLogFileScavenger(g g2) {
        if (this.logFileScavenger != null) {
            this.logFileScavenger.end();
        }
        TimeAndSizeRollingAppender timeAndSizeRollingAppender = this;
        g2.init(timeAndSizeRollingAppender, timeAndSizeRollingAppender.getProperties());
        this.logFileScavenger = g2;
        return g2;
    }

    private void setLogFileCompressor(LogFileCompressor logFileCompressor) {
        if (this.logFileCompressor != null) {
            this.logFileCompressor.end();
        }
        this.logFileCompressor = logFileCompressor;
    }

    private TimeBasedRollEnforcer getLogRollEnforcer() {
        return this.logRollEnforcer;
    }

    private void setLogRollEnforcer(TimeBasedRollEnforcer timeBasedRollEnforcer) {
        if (this.logRollEnforcer != null) {
            this.logRollEnforcer.end();
        }
        this.logRollEnforcer = timeBasedRollEnforcer;
    }
}

