/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.ScheduledFileRollEvent;
import uk.org.simonsite.log4j.appender.TimeAndSizeRollingAppender;

final class TimeBasedRollEnforcer
implements Runnable {
    private static final long TIME_OFFSET = 1000L;
    private final TimeAndSizeRollingAppender appender;
    private final AppenderRollingProperties properties;
    private volatile Thread threadRef = null;
    private long nextEnforcedRollTimeMillis = 0L;

    TimeBasedRollEnforcer(TimeAndSizeRollingAppender timeAndSizeRollingAppender) {
        this.appender = timeAndSizeRollingAppender;
        this.properties = timeAndSizeRollingAppender.getProperties();
    }

    @Override
    public final void run() {
        LogLog.debug((String)"Log time-based file-roll enforcer started");
        try {
            while (this.isRunning()) {
                try {
                    this.enforceRollSchedule();
                    Thread.sleep(this.sleepInterval());
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Exception exception) {
            this.appender.getErrorHandler().error("Log time-based file-roll enforcer failed", exception, 0);
        }
        LogLog.debug((String)"Log time-based file-roll enforcer stopped");
    }

    final synchronized void begin() {
        if (this.threadRef == null && this.properties.isDateRollEnforced()) {
            Thread thread;
            this.threadRef = thread = new Thread((Runnable)this, "Log4J Time-based File-roll Enforcer");
            thread.setDaemon(true);
            thread.start();
        }
    }

    final synchronized void end() {
        Thread thread = this.threadRef;
        this.threadRef = null;
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean isScheduledRollTimeExceeded(long l2) {
        return l2 > this.properties.getNextRollOverTime();
    }

    private boolean isRunning() {
        Thread thread = this.threadRef;
        if (thread != null) {
            return !thread.isInterrupted();
        }
        return false;
    }

    private void enforceRollSchedule() {
        long l2 = this.nextEnforcedRollTimeMillis;
        if (this.isScheduledRollTimeExceeded(l2)) {
            ScheduledFileRollEvent scheduledFileRollEvent = new ScheduledFileRollEvent(this.appender, l2);
            scheduledFileRollEvent.dispatchToAppender();
        }
        TimeBasedRollEnforcer timeBasedRollEnforcer = this;
        timeBasedRollEnforcer.updateNextEnforcedRollTime(timeBasedRollEnforcer.properties.getNextRollOverTimeWithWait());
    }

    private void updateNextEnforcedRollTime(long l2) {
        this.nextEnforcedRollTimeMillis = l2 + 1000L;
    }

    private long sleepInterval() {
        long l2 = this.nextEnforcedRollTimeMillis - System.currentTimeMillis();
        if (l2 < 0L) {
            return 1000L;
        }
        return l2;
    }
}

