/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.util.Calendar;
import java.util.regex.Pattern;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.LocalizedDateFormatPatternHelper;

abstract class TimeBasedRollStrategy {
    static final TimeBasedRollStrategy ROLL_ERROR = new TimeBasedRollStrategy(){

        @Override
        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper localizedDateFormatPatternHelper, String string) {
            return false;
        }

        @Override
        final long nextRollTimeInMillis(long l2, AppenderRollingProperties appenderRollingProperties) {
            return 0L;
        }

        public final String toString() {
            return "error";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_MINUTE = new TimeBasedRollStrategy(){

        @Override
        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper object, String string) {
            object = ((LocalizedDateFormatPatternHelper)object).minutePatternRegex();
            return Pattern.matches((String)object, string);
        }

        @Override
        final long nextRollTimeInMillis(long l2, AppenderRollingProperties object) {
            object = Calendar.getInstance(((AppenderRollingProperties)object).getTimeZone(), ((AppenderRollingProperties)object).getDatePatternLocale());
            ((Calendar)object).setTimeInMillis(l2);
            ((Calendar)object).set(14, 0);
            ((Calendar)object).set(13, 0);
            ((Calendar)object).add(12, 1);
            return ((Calendar)object).getTimeInMillis();
        }

        public final String toString() {
            return "every minute";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_HOUR = new TimeBasedRollStrategy(){

        @Override
        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper object, String string) {
            object = ((LocalizedDateFormatPatternHelper)object).hourPatternRegex();
            return Pattern.matches((String)object, string);
        }

        @Override
        final long nextRollTimeInMillis(long l2, AppenderRollingProperties object) {
            object = Calendar.getInstance(((AppenderRollingProperties)object).getTimeZone(), ((AppenderRollingProperties)object).getDatePatternLocale());
            ((Calendar)object).setTimeInMillis(l2);
            ((Calendar)object).set(14, 0);
            ((Calendar)object).set(13, 0);
            ((Calendar)object).set(12, 0);
            ((Calendar)object).add(11, 1);
            return ((Calendar)object).getTimeInMillis();
        }

        public final String toString() {
            return "hourly";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_HALF_DAY = new TimeBasedRollStrategy(){

        @Override
        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper object, String string) {
            object = ((LocalizedDateFormatPatternHelper)object).amPmPatternRegex();
            return Pattern.matches((String)object, string);
        }

        @Override
        final long nextRollTimeInMillis(long l2, AppenderRollingProperties object) {
            object = Calendar.getInstance(((AppenderRollingProperties)object).getTimeZone(), ((AppenderRollingProperties)object).getDatePatternLocale());
            ((Calendar)object).setTimeInMillis(l2);
            ((Calendar)object).set(14, 0);
            ((Calendar)object).set(13, 0);
            ((Calendar)object).set(12, 0);
            int n = ((Calendar)object).get(11);
            if (n < 12) {
                ((Calendar)object).set(11, 12);
            } else {
                ((Calendar)object).set(11, 0);
                ((Calendar)object).add(5, 1);
            }
            return ((Calendar)object).getTimeInMillis();
        }

        public final String toString() {
            return "half-daily";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_DAY = new TimeBasedRollStrategy(){

        @Override
        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper object, String string) {
            object = ((LocalizedDateFormatPatternHelper)object).dayPatternRegex();
            return Pattern.matches((String)object, string);
        }

        @Override
        final long nextRollTimeInMillis(long l2, AppenderRollingProperties object) {
            object = Calendar.getInstance(((AppenderRollingProperties)object).getTimeZone(), ((AppenderRollingProperties)object).getDatePatternLocale());
            ((Calendar)object).setTimeInMillis(l2);
            ((Calendar)object).set(14, 0);
            ((Calendar)object).set(13, 0);
            ((Calendar)object).set(12, 0);
            ((Calendar)object).set(11, 0);
            ((Calendar)object).add(5, 1);
            return ((Calendar)object).getTimeInMillis();
        }

        public final String toString() {
            return "daily";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_WEEK = new TimeBasedRollStrategy(){

        @Override
        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper object, String string) {
            object = ((LocalizedDateFormatPatternHelper)object).weekPatternRegex();
            return Pattern.matches((String)object, string);
        }

        @Override
        final long nextRollTimeInMillis(long l2, AppenderRollingProperties object) {
            object = Calendar.getInstance(((AppenderRollingProperties)object).getTimeZone(), ((AppenderRollingProperties)object).getDatePatternLocale());
            ((Calendar)object).setTimeInMillis(l2);
            ((Calendar)object).set(14, 0);
            ((Calendar)object).set(13, 0);
            ((Calendar)object).set(12, 0);
            ((Calendar)object).set(11, 0);
            ((Calendar)object).set(7, ((Calendar)object).getFirstDayOfWeek());
            ((Calendar)object).add(3, 1);
            return ((Calendar)object).getTimeInMillis();
        }

        public final String toString() {
            return "weekly";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_MONTH = new TimeBasedRollStrategy(){

        @Override
        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper object, String string) {
            object = ((LocalizedDateFormatPatternHelper)object).monthPatternRegex();
            return Pattern.matches((String)object, string);
        }

        @Override
        final long nextRollTimeInMillis(long l2, AppenderRollingProperties object) {
            object = Calendar.getInstance(((AppenderRollingProperties)object).getTimeZone(), ((AppenderRollingProperties)object).getDatePatternLocale());
            ((Calendar)object).setTimeInMillis(l2);
            ((Calendar)object).set(14, 0);
            ((Calendar)object).set(13, 0);
            ((Calendar)object).set(12, 0);
            ((Calendar)object).set(11, 0);
            ((Calendar)object).set(5, 1);
            ((Calendar)object).add(2, 1);
            return ((Calendar)object).getTimeInMillis();
        }

        public final String toString() {
            return "monthly";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_YEAR = new TimeBasedRollStrategy(){

        @Override
        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper object, String string) {
            object = ((LocalizedDateFormatPatternHelper)object).yearPatternRegex();
            return Pattern.matches((String)object, string);
        }

        @Override
        final long nextRollTimeInMillis(long l2, AppenderRollingProperties object) {
            object = Calendar.getInstance(((AppenderRollingProperties)object).getTimeZone(), ((AppenderRollingProperties)object).getDatePatternLocale());
            ((Calendar)object).setTimeInMillis(l2);
            ((Calendar)object).set(14, 0);
            ((Calendar)object).set(13, 0);
            ((Calendar)object).set(12, 0);
            ((Calendar)object).set(11, 0);
            ((Calendar)object).set(5, 1);
            ((Calendar)object).set(2, 1);
            ((Calendar)object).add(1, 1);
            return ((Calendar)object).getTimeInMillis();
        }

        public final String toString() {
            return "annually";
        }
    };

    TimeBasedRollStrategy() {
    }

    static final TimeBasedRollStrategy findRollStrategy(AppenderRollingProperties object) {
        if (((AppenderRollingProperties)object).getDatePattern() == null) {
            LogLog.error((String)"null date pattern");
            return ROLL_ERROR;
        }
        LocalizedDateFormatPatternHelper localizedDateFormatPatternHelper = new LocalizedDateFormatPatternHelper(((AppenderRollingProperties)object).getDatePatternLocale());
        if (ROLL_EACH_MINUTE.isRequiredStrategy(localizedDateFormatPatternHelper, (String)(object = localizedDateFormatPatternHelper.excludeQuoted(((AppenderRollingProperties)object).getDatePattern())))) {
            return ROLL_EACH_MINUTE;
        }
        if (ROLL_EACH_HOUR.isRequiredStrategy(localizedDateFormatPatternHelper, (String)object)) {
            return ROLL_EACH_HOUR;
        }
        if (ROLL_EACH_HALF_DAY.isRequiredStrategy(localizedDateFormatPatternHelper, (String)object)) {
            return ROLL_EACH_HALF_DAY;
        }
        if (ROLL_EACH_DAY.isRequiredStrategy(localizedDateFormatPatternHelper, (String)object)) {
            return ROLL_EACH_DAY;
        }
        if (ROLL_EACH_WEEK.isRequiredStrategy(localizedDateFormatPatternHelper, (String)object)) {
            return ROLL_EACH_WEEK;
        }
        if (ROLL_EACH_MONTH.isRequiredStrategy(localizedDateFormatPatternHelper, (String)object)) {
            return ROLL_EACH_MONTH;
        }
        if (ROLL_EACH_YEAR.isRequiredStrategy(localizedDateFormatPatternHelper, (String)object)) {
            return ROLL_EACH_YEAR;
        }
        return ROLL_ERROR;
    }

    abstract boolean isRequiredStrategy(LocalizedDateFormatPatternHelper var1, String var2);

    abstract long nextRollTimeInMillis(long var1, AppenderRollingProperties var3);
}

