/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.helpers;

import java.io.File;
import org.apache.log4j.helpers.LogLog;

public final class FileHelper {
    private static final FileHelper INSTANCE = new FileHelper();
    private static final long MAGIC_ZIP = 67324752L;
    private static final long MAGIC_GZIP = 35615L;

    public static final FileHelper getInstance() {
        return INSTANCE;
    }

    private FileHelper() {
    }

    public final long sizeOf(File file) {
        if (this.isReadable(file)) {
            return file.length();
        }
        return 0L;
    }

    public final boolean isEmpty(File file) {
        return this.sizeOf(file) == 0L;
    }

    public final boolean deleteExisting(File file) {
        if (!file.exists()) {
            return true;
        }
        boolean bl = false;
        if (file.canWrite()) {
            bl = file.delete();
        } else {
            LogLog.debug((String)(file + " is not writeable for delete (retrying)"));
        }
        if (!bl) {
            boolean bl2;
            if (!file.exists()) {
                bl2 = true;
            } else {
                file.delete();
                bl2 = !file.exists();
            }
            bl = bl2;
        }
        return bl;
    }

    public final boolean rename(File file, File file2) {
        boolean bl = false;
        if (this.isWriteable(file)) {
            bl = file.renameTo(file2);
        } else {
            LogLog.debug((String)(file + " is not writeable for rename (retrying)"));
        }
        if (!bl) {
            file.renameTo(file2);
            bl = !file.exists();
        }
        return bl;
    }

    public final boolean isReadable(File file) {
        return file.exists() && file.canRead();
    }

    public final boolean isWriteable(File file) {
        return file.exists() && file.canWrite();
    }

    public final File parentDirOf(File file) {
        if ((file = file.getParentFile()) == null) {
            file = new File(System.getProperty("user.dir"));
        }
        return file;
    }

    public final boolean isCompressed(File file) {
        return this.isZip(file) || this.isGZip(file);
    }

    public final boolean isZip(File file) {
        long l2 = 0L;
        if (this.isReadable(file)) {
            byte[] byArray = new byte[4];
            this.readBytes(file, byArray);
            l2 = this.getUnsigned32Bit(byArray, 0);
        }
        return 67324752L == l2;
    }

    public final boolean isGZip(File file) {
        long l2 = 0L;
        if (this.isReadable(file)) {
            byte[] byArray = new byte[2];
            this.readBytes(file, byArray);
            l2 = this.getUnsigned16Bit(byArray, 0);
        }
        return 35615L == l2;
    }

    private int getUnsigned16Bit(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private long getUnsigned32Bit(byte[] byArray, int n) {
        return (long)this.getUnsigned16Bit(byArray, n) | (long)this.getUnsigned16Bit(byArray, n + 2) << 16;
    }

    /*
     * Exception decompiling
     */
    private void readBytes(File var1_1, byte[] var2_10) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

