/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eio;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileManager {
    public static final short kOnAppropriateDisk = -32767;
    public static final short kSystemDomain = -32766;
    public static final short kLocalDomain = -32765;
    public static final short kNetworkDomain = -32764;
    public static final short kUserDomain = -32763;

    public static int OSTypeToInt(String string) {
        int n = 0;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        int n2 = string.length();
        if (n2 > 0) {
            if (n2 > 4) {
                n2 = 4;
            }
            string.getBytes(0, n2, byArray, 4 - n2);
        }
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                n <<= 8;
            }
            n |= byArray[i] & 0xFF;
        }
        return n;
    }

    public static void setFileTypeAndCreator(String string, int n, int n2) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        FileManager._setFileTypeAndCreator(string, n, n2);
    }

    private static native void _setFileTypeAndCreator(String var0, int var1, int var2) throws IOException;

    public static void setFileType(String string, int n) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        FileManager._setFileType(string, n);
    }

    private static native void _setFileType(String var0, int var1) throws IOException;

    public static void setFileCreator(String string, int n) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        FileManager._setFileCreator(string, n);
    }

    private static native void _setFileCreator(String var0, int var1) throws IOException;

    public static int getFileType(String string) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        return FileManager._getFileType(string);
    }

    private static native int _getFileType(String var0) throws IOException;

    public static int getFileCreator(String string) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        return FileManager._getFileCreator(string);
    }

    private static native int _getFileCreator(String var0) throws IOException;

    public static String findFolder(int n) throws FileNotFoundException {
        return FileManager.findFolder((short)-32767, n);
    }

    public static String findFolder(short s, int n) throws FileNotFoundException {
        return FileManager.findFolder(s, n, false);
    }

    public static String findFolder(short s, int n, boolean bl) throws FileNotFoundException {
        String string;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("canExamineFileSystem"));
        }
        if ((string = FileManager._findFolder(s, n, bl)) == null) {
            throw new FileNotFoundException("Can't find folder: " + Integer.toHexString(n));
        }
        return string;
    }

    private static native String _findFolder(short var0, int var1, boolean var2);

    @Deprecated
    public static void openURL(String string) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("canOpenURLs"));
        }
        FileManager._openURL(string);
    }

    private static native void _openURL(String var0) throws IOException;

    public static String getResource(String string) throws FileNotFoundException {
        return FileManager.getResourceFromBundle(string, null, null);
    }

    public static String getResource(String string, String string2) throws FileNotFoundException {
        return FileManager.getResourceFromBundle(string, string2, null);
    }

    public static String getResource(String string, String string2, String string3) throws FileNotFoundException {
        return FileManager.getResourceFromBundle(string, string2, string3);
    }

    private static native String getNativeResourceFromBundle(String var0, String var1, String var2) throws FileNotFoundException;

    private static String getResourceFromBundle(String string, String string2, String string3) throws FileNotFoundException {
        String string4;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("canReadBundle"));
        }
        if ((string4 = FileManager.getNativeResourceFromBundle(string, string2, string3)) == null) {
            throw new FileNotFoundException(string);
        }
        return string4;
    }

    public static String getPathToApplicationBundle() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("canReadBundle"));
        }
        return FileManager.getNativePathToApplicationBundle();
    }

    private static native String getNativePathToApplicationBundle();

    public static boolean moveToTrash(File file) throws FileNotFoundException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        String string = file.getAbsolutePath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        return FileManager._moveToTrash(string);
    }

    private static native boolean _moveToTrash(String var0);

    public static boolean revealInFinder(File file) throws FileNotFoundException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        String string = file.getAbsolutePath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        return FileManager._revealInFinder(string);
    }

    private static native boolean _revealInFinder(String var0);

    static {
        Toolkit.getDefaultToolkit();
    }
}

