/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.LogFileCompressionStrategy;
import uk.org.simonsite.log4j.helpers.FileHelper;

final class GzipFileCompressionStrategy
extends LogFileCompressionStrategy {
    private static final int DEFLATER_BUFFER_SIZE = 131071;

    GzipFileCompressionStrategy() {
    }

    @Override
    final String getAlgorithmName() {
        return "gz";
    }

    @Override
    final boolean isCompressed(File file) {
        return FileHelper.getInstance().isGZip(file);
    }

    @Override
    final boolean compress(File object, File object2, AppenderRollingProperties appenderRollingProperties) {
        if ((object = this.createInputStream((File)object)) == null) {
            return false;
        }
        if ((object2 = this.createGZipOutputStream((File)object2, appenderRollingProperties)) == null) {
            return false;
        }
        return this.compress((FileInputStream)object, (GZIPOutputStream)object2);
    }

    private FileInputStream createInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogLog.debug((String)"Unable to open backup log file", (Throwable)fileNotFoundException);
            return null;
        }
    }

    private GZIPOutputStream createGZipOutputStream(File file, AppenderRollingProperties appenderRollingProperties) {
        try {
            return new GZIPOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), 131071);
        }
        catch (IOException iOException) {
            LogLog.warn((String)"Unable to open compressed log file", (Throwable)iOException);
            return null;
        }
    }

    private boolean compress(FileInputStream fileInputStream, GZIPOutputStream gZIPOutputStream) {
        long l2 = System.currentTimeMillis();
        FileChannel fileChannel = null;
        WritableByteChannel writableByteChannel = null;
        try {
            fileChannel = fileInputStream.getChannel();
            writableByteChannel = Channels.newChannel(gZIPOutputStream);
            fileChannel.transferTo(0L, fileChannel.size(), writableByteChannel);
            gZIPOutputStream.finish();
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            LogLog.debug((String)"Compression operation interrupted");
            return false;
        }
        catch (IOException iOException) {
            LogLog.warn((String)"Unable to transfer data from backup log file to compressed log file", (Throwable)iOException);
            return false;
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {
                    LogLog.warn((String)"Unable to close backup log file", (Throwable)iOException);
                }
            }
            if (writableByteChannel != null) {
                try {
                    writableByteChannel.close();
                }
                catch (IOException iOException) {
                    LogLog.warn((String)"Unable to close compressed log file", (Throwable)iOException);
                }
            }
        }
        LogLog.debug((String)("Compressed in " + (System.currentTimeMillis() - l2) + "ms"));
        return true;
    }
}

