/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.GzipFileCompressionStrategy;
import uk.org.simonsite.log4j.appender.i;
import uk.org.simonsite.log4j.helpers.FileHelper;

abstract class LogFileCompressionStrategy {
    static final LogFileCompressionStrategy ZIP = new i();
    static final LogFileCompressionStrategy GZIP = new GzipFileCompressionStrategy();
    static final LogFileCompressionStrategy DEFAULT = new LogFileCompressionStrategy(){

        @Override
        final boolean compress(File file, File file2, AppenderRollingProperties appenderRollingProperties) {
            return false;
        }

        @Override
        final String getAlgorithmName() {
            return "error";
        }

        @Override
        final boolean isCompressed(File file) {
            return true;
        }
    };
    private static final LogFileCompressionStrategy[] COMPRESSION_STRATEGIES = new LogFileCompressionStrategy[]{ZIP, GZIP};

    LogFileCompressionStrategy() {
    }

    static final boolean existsFor(AppenderRollingProperties appenderRollingProperties) {
        return !DEFAULT.equals(LogFileCompressionStrategy.findCompressionStrategy(appenderRollingProperties));
    }

    static final LogFileCompressionStrategy findCompressionStrategy(AppenderRollingProperties appenderRollingProperties) {
        if (ZIP.isRequiredStrategy(appenderRollingProperties)) {
            LogLog.debug((String)"Using ZIP compression");
            return ZIP;
        }
        if (GZIP.isRequiredStrategy(appenderRollingProperties)) {
            LogLog.debug((String)"Using GZIP compression");
            return GZIP;
        }
        LogLog.debug((String)"Not using compression");
        return DEFAULT;
    }

    static final LogFileCompressionStrategy[] strategies() {
        return COMPRESSION_STRATEGIES;
    }

    abstract boolean compress(File var1, File var2, AppenderRollingProperties var3);

    abstract String getAlgorithmName();

    abstract boolean isCompressed(File var1);

    final boolean isRequiredStrategy(AppenderRollingProperties appenderRollingProperties) {
        return this.getAlgorithmName().equalsIgnoreCase(appenderRollingProperties.getCompressionAlgorithm());
    }

    final File compress(File file, AppenderRollingProperties appenderRollingProperties) {
        if (this.isCompressed(file)) {
            LogLog.debug((String)("Backup log file " + file.getName() + " is already compressed"));
            return file;
        }
        long l2 = file.lastModified();
        if (0L == l2) {
            LogLog.debug((String)("Backup log file " + file.getName() + " may have been scavenged"));
            return null;
        }
        File file2 = this.createDeflatedFile(file);
        if (file2 == null) {
            LogLog.debug((String)("Backup log file " + file.getName() + " may have been scavenged"));
            return null;
        }
        if (this.compress(file, file2, appenderRollingProperties)) {
            file2.setLastModified(l2);
            FileHelper.getInstance().deleteExisting(file);
            LogLog.debug((String)("Compressed backup log file to " + file2.getName()));
            return file2;
        }
        FileHelper.getInstance().deleteExisting(file2);
        LogLog.debug((String)("Unable to compress backup log file " + file.getName()));
        return null;
    }

    private File createDeflatedFile(File file) {
        try {
            FileHelper fileHelper = FileHelper.getInstance();
            file = new File(fileHelper.parentDirOf(file), file.getName() + '.' + this.getAlgorithmName());
            fileHelper.deleteExisting(file);
            if (file.createNewFile()) {
                return file;
            }
            LogLog.warn((String)"Unable to create compressed backup log file");
            return null;
        }
        catch (IOException iOException) {
            LogLog.error((String)"Unable to create compressed backup log file", (Throwable)iOException);
            return null;
        }
    }
}

