/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.FileCompressionEvent;
import uk.org.simonsite.log4j.appender.FileRollEvent;
import uk.org.simonsite.log4j.appender.LogFileCompressionStrategy;
import uk.org.simonsite.log4j.appender.TimeAndSizeRollingAppender;
import uk.org.simonsite.log4j.appender.b;
import uk.org.simonsite.log4j.appender.c;
import uk.org.simonsite.log4j.helpers.FileHelper;

final class LogFileCompressor
implements Runnable,
c {
    private static final int QUEUE_LIMIT = 64;
    private final TimeAndSizeRollingAppender appender;
    private final AppenderRollingProperties properties;
    private volatile Thread threadRef = null;
    private final List queue;
    private final List fileCompressionEventListeners;

    LogFileCompressor(TimeAndSizeRollingAppender timeAndSizeRollingAppender) {
        this.appender = timeAndSizeRollingAppender;
        this.properties = timeAndSizeRollingAppender.getProperties();
        this.queue = new LinkedList();
        this.fileCompressionEventListeners = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public final void run() {
        LogLog.debug((String)"Log file compressor started");
        try {
            while (this.isRunning()) {
                try {
                    this.compressNext();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (InterruptedIOException interruptedIOException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Exception exception) {
            this.appender.getErrorHandler().error("Log file compressor failed", exception, 0);
        }
        LogLog.debug((String)"Log file compressor stopped");
    }

    @Override
    public final void onFileRoll(FileRollEvent fileRollEvent) {
        this.compress(fileRollEvent.getBackupFile());
    }

    final int getQueueLimit() {
        return 64;
    }

    final int getQueueSize() {
        int n;
        List list = this.queue;
        synchronized (list) {
            n = this.queue.size();
            this.queue.notifyAll();
        }
        return n;
    }

    final void waitForEmptyQueue() {
        this.waitForSizeQueue(0);
    }

    final void waitForSizeQueue(int n) {
        List list = this.queue;
        synchronized (list) {
            while (this.queue.size() > n) {
                try {
                    this.queue.wait(250L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            this.queue.notifyAll();
            return;
        }
    }

    final synchronized void begin() {
        if (this.threadRef == null && LogFileCompressionStrategy.existsFor(this.properties)) {
            Thread thread;
            this.threadRef = thread = new Thread((Runnable)this, "Log4J File Compressor");
            thread.setDaemon(true);
            thread.start();
        }
    }

    final synchronized void end() {
        Thread thread = this.threadRef;
        this.threadRef = null;
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    final void compress(File file) {
        if (this.isRunning()) {
            List list = this.queue;
            synchronized (list) {
                while (this.queue.size() > 64) {
                    if (this.properties.isCompressionBlocking()) {
                        try {
                            this.queue.wait(this.properties.getCompressionMaxWait());
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    this.queue.remove(0);
                }
                this.queue.add(file);
                this.queue.notifyAll();
                return;
            }
        }
    }

    final void addFileCompressionEventListener(b b2) {
        this.fileCompressionEventListeners.add(b2);
    }

    final void removeFileCompressionEventListener(b b2) {
        this.fileCompressionEventListeners.remove(b2);
    }

    final void fireFileCompressionEvent(FileCompressionEvent objectArray) {
        objectArray = this.fileCompressionEventListeners.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
        }
    }

    private boolean isRunning() {
        Thread thread = this.threadRef;
        if (thread != null) {
            return !thread.isInterrupted();
        }
        return false;
    }

    private boolean queueBelowMinSize() {
        int n;
        List list = this.queue;
        synchronized (list) {
            n = this.properties.getCompressionMinQueueSize();
            n = n > 0 ? (this.queue.size() < n ? 1 : 0) : (int)(this.queue.isEmpty() ? 1 : 0);
            this.queue.notifyAll();
        }
        return n != 0;
    }

    private void compressNext() throws InterruptedException, InterruptedIOException {
        File file;
        List list = this.queue;
        synchronized (list) {
            while (this.queueBelowMinSize()) {
                this.queue.wait(this.properties.getCompressionMaxWait());
            }
            file = (File)this.queue.remove(0);
            this.queue.notifyAll();
        }
        if (file != null) {
            this.doCompression(file);
        }
    }

    private void doCompression(File file) {
        LogFileCompressionStrategy logFileCompressionStrategy;
        if (FileHelper.getInstance().isWriteable(file) && (logFileCompressionStrategy = LogFileCompressionStrategy.findCompressionStrategy(this.properties)) != null && (file = logFileCompressionStrategy.compress(file, this.properties)) != null) {
            this.fireFileCompressionEvent(new FileCompressionEvent(file));
        }
    }
}

