/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.io.FilenameFilter;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.BackupSuffixHelper;
import uk.org.simonsite.log4j.helpers.FileHelper;

final class LogFileList
extends AbstractList
implements List {
    private final BackupSuffixHelper backupSuffixHelper;
    private final File baseFile;
    private final FileHelper fileHelper;
    private File[] fileArray;
    private int size;
    private final FilenameFilter filenameFilter;

    LogFileList(File file, FilenameFilter filenameFilter, AppenderRollingProperties appenderRollingProperties) {
        this.backupSuffixHelper = new BackupSuffixHelper(appenderRollingProperties);
        this.baseFile = file;
        this.fileArray = new File[0];
        this.fileHelper = FileHelper.getInstance();
        this.filenameFilter = filenameFilter;
        this.init();
    }

    public final Object get(int n) {
        this.rangeCheck(n);
        return this.fileArray[n];
    }

    public final Object remove(int n) {
        this.rangeCheck(n);
        ++this.modCount;
        File file = this.fileArray[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.fileArray, n + 1, this.fileArray, n, n2);
        }
        this.fileArray[--this.size] = null;
        return file;
    }

    @Override
    public final int size() {
        return this.size;
    }

    final File firstFile() {
        if (this.size > 0) {
            return this.fileArray[0];
        }
        return null;
    }

    final File lastFile() {
        if (this.size > 0) {
            return this.fileArray[this.size - 1];
        }
        return null;
    }

    private void init() {
        File file = this.baseFile.isDirectory() ? this.baseFile : this.fileHelper.parentDirOf(this.baseFile);
        if (file != null) {
            this.readFileListFrom(file);
            this.sortFileList();
        }
    }

    private void rangeCheck(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    private void readFileListFrom(File fileArray) {
        if (this.fileHelper.isReadable((File)fileArray) && (fileArray = this.filenameFilter != null ? fileArray.listFiles(this.filenameFilter) : fileArray.listFiles()) != null) {
            this.fileArray = fileArray;
            this.size = fileArray.length;
        }
    }

    private void sortFileList() {
        if (this.size > 1) {
            Arrays.sort(this.fileArray, new Comparator(){

                public final int compare(Object object, Object object2) {
                    int n;
                    object = (File)object;
                    object2 = (File)object2;
                    Number[] numberArray = LogFileList.this.backupSuffixHelper.backupTimeAndCount(((File)object).getName(), LogFileList.this.baseFile);
                    Number[] numberArray2 = LogFileList.this.backupSuffixHelper.backupTimeAndCount(((File)object2).getName(), LogFileList.this.baseFile);
                    long l2 = numberArray[0].longValue();
                    long l3 = numberArray2[0].longValue();
                    if (0L == l2 && 0L == l3) {
                        long l4;
                        long l5 = ((File)object).lastModified();
                        if (l5 < (l4 = ((File)object2).lastModified())) {
                            return -1;
                        }
                        if (l5 > l4) {
                            return 1;
                        }
                        return 0;
                    }
                    if (l2 < l3) {
                        return -1;
                    }
                    if (l2 > l3) {
                        return 1;
                    }
                    int n2 = numberArray[1].intValue();
                    if (n2 < (n = numberArray2[1].intValue())) {
                        return -1;
                    }
                    if (n2 > n) {
                        return 1;
                    }
                    if (n2 == n) {
                        if (LogFileList.this.fileHelper.isCompressed((File)object)) {
                            return -1;
                        }
                        if (LogFileList.this.fileHelper.isCompressed((File)object2)) {
                            return 1;
                        }
                    }
                    return 0;
                }
            });
        }
    }
}

