/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import uk.org.simonsite.log4j.appender.AbstractRoller;
import uk.org.simonsite.log4j.appender.TimeAndSizeRollingAppender;
import uk.org.simonsite.log4j.appender.TimeBasedRollStrategy;
import uk.org.simonsite.log4j.appender.e;
import uk.org.simonsite.log4j.helpers.FileHelper;

final class TimeBasedRoller
extends AbstractRoller
implements e {
    private final TimeBasedRollStrategy rollStrategy;
    private TimeSample currentSample;
    private TimeSample previousSample;

    TimeBasedRoller(TimeAndSizeRollingAppender timeAndSizeRollingAppender) {
        super(timeAndSizeRollingAppender);
        TimeBasedRollStrategy timeBasedRollStrategy = TimeBasedRollStrategy.findRollStrategy(timeAndSizeRollingAppender.getProperties());
        if (TimeBasedRollStrategy.ROLL_ERROR.equals(timeBasedRollStrategy)) {
            timeBasedRollStrategy = TimeBasedRollStrategy.ROLL_EACH_DAY;
            LogLog.warn((String)("Unable to parse date pattern [" + timeAndSizeRollingAppender.getProperties().getDatePattern() + "] configured on appender [" + timeAndSizeRollingAppender.getName() + "], defaulting to roll " + timeBasedRollStrategy.toString()));
        }
        LogLog.debug((String)("Appender [" + timeAndSizeRollingAppender.getName() + "] to be rolled " + timeBasedRollStrategy.toString()));
        this.rollStrategy = timeBasedRollStrategy;
        this.currentSample = new TimeSample(System.currentTimeMillis());
        this.initNextRolloverTime();
    }

    @Override
    public final boolean roll(LoggingEvent loggingEvent) {
        boolean bl = false;
        this.takeTimeSample(loggingEvent);
        long l2 = this.getNextRolloverTimeMillis();
        if (this.isRolloverDue(l2)) {
            TimeBasedRoller timeBasedRoller = this;
            super.roll(timeBasedRoller.sampledTime());
            this.updateNextRolloverTime();
            bl = true;
        }
        this.storeTimeSample();
        return bl;
    }

    final TimeBasedRollStrategy getRollStrategy() {
        return this.rollStrategy;
    }

    private void takeTimeSample(LoggingEvent loggingEvent) {
        this.currentSample = new TimeSample(loggingEvent.getTimeStamp());
    }

    private long sampledTime() {
        if (this.previousSample == null) {
            File file = super.getAppender().getIoFile();
            this.previousSample = FileHelper.getInstance().isReadable(file) ? new TimeSample(file.lastModified()) : this.currentSample;
        }
        return this.previousSample.getMillis();
    }

    private void storeTimeSample() {
        if (this.currentSample.isAtOrAfter(this.previousSample)) {
            this.previousSample = this.currentSample;
            this.currentSample = null;
        }
    }

    private long getNextRolloverTimeMillis() {
        return this.getProperties().getNextRollOverTime();
    }

    private void setNextRolloverTimeMillis(long l2) {
        this.getProperties().setNextRollOverTime(l2);
    }

    private boolean isRolloverDue(long l2) {
        return this.currentSample.isAtOrAfter(l2);
    }

    private void initNextRolloverTime() {
        this.updateNextRolloverTime();
        File file = super.getAppender().getIoFile();
        if (FileHelper.getInstance().isReadable(file)) {
            long l2 = this.rollStrategy.nextRollTimeInMillis(file.lastModified(), super.getProperties());
            if (l2 < this.getNextRolloverTimeMillis()) {
                this.setNextRolloverTimeMillis(l2);
            }
            return;
        }
        super.getAppender().getErrorHandler().error("Unable to initialise next rollover time based upon last modification time of " + String.valueOf(file) + " because the file is not readable");
    }

    private void updateNextRolloverTime() {
        long l2 = this.currentSample.getMillis();
        long l3 = this.rollStrategy.nextRollTimeInMillis(l2, super.getProperties());
        this.setNextRolloverTimeMillis(l3);
    }

    private final class TimeSample {
        private final long sample;

        TimeSample(long l2) {
            this.sample = l2;
        }

        final long getMillis() {
            return this.sample;
        }

        final boolean isAtOrAfter(long l2) {
            return this.sample >= l2;
        }

        final boolean isAtOrAfter(TimeSample timeSample) {
            return timeSample == null || this.sample >= timeSample.sample;
        }
    }
}

