/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.helpers;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import org.apache.log4j.helpers.QuietWriter;
import org.apache.log4j.spi.ErrorHandler;

public final class SynchronizedCountingQuietWriter
extends QuietWriter {
    private long charCount;

    public SynchronizedCountingQuietWriter(Writer writer, ErrorHandler errorHandler) {
        super(writer, errorHandler);
    }

    public final void write(String string) {
        if (string == null) {
            this.errorHandler.error("Attempt to write null - see Log4J bug list.", (Exception)new RuntimeException("Fault in Log4J Layout"), 1);
            return;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                int n = string.length();
                this.out.write(string, 0, n);
                this.charCount += (long)n;
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            if (iOException instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            this.errorHandler.error("Failed to write [" + string + "].", (Exception)iOException2, 1);
        }
    }

    public final void flush() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this.errorHandler.error("Failed to flush writer,", (Exception)iOException, 2);
        }
    }

    public final void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.close();
            return;
        }
    }

    public final long getCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.charCount;
        }
    }

    public final void setCount(long l2) {
        Object object = this.lock;
        synchronized (object) {
            this.charCount = l2;
            return;
        }
    }
}

